/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


let contents = Repository.query("//element(*, ametys:content)[@ametys-internal:contentType = 'org.ametys.plugins.odf.Content.program' or @ametys-internal:contentType = 'org.ametys.plugins.odf.Content.subProgram']");

let total = contents.getSize();
let handled = 0;
let count = 0;

logger.info(`Start to migrate apprenticeship modalities' attribute for ${total} contents`);

contents.forEach(
    content =>
    {
        Content.migrate( 
            content, 
            [_moveApprenticeshipModalitiesProperty], 
            true, /* old version still comptatible */ 
            null, /* no tag */ 
            false, /* verbose */
            true /* synchronize live */
        );
        
        handled++;
        if (handled % 200 == 0)
        {
            logger.info(`${handled}/${total} handled programs or subprograms`);
        }
    }
);

logger.info(`${count} contents have been updated to migrate apprenticeship modalities' attribute`);

function _moveApprenticeshipModalitiesProperty(content)
{
    const contentNode = content.getNode();
    if (contentNode.hasNode("ametys:alternationModality"))
    {
        const node = contentNode.getNode("ametys:alternationModality");
        node.getSession().move(node.getPath(), contentNode.getPath() + "/ametys:apprenticeshipModalities");
        count++;
    }
}