/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.odf.cdmfr;

import org.ametys.plugins.repository.AmetysObject;

/**
 * Object exportable in CDM-fr format.
 */
public interface CDMEntity extends CDMFRTagsConstants, AmetysObject
{
    /** Constants for metadata CDM code */
    public static final String CDM_CODE = "cdmCode";
    
    /**
     * Returns the CDM id.
     * @return the CDM id.
     */
    public String getCDMId();
    
    /**
     * Returns the main language of this object.
     * @return the main language of this object.
     */
    public String getLanguage();
    
    /**
     * Get the CDM code.
     * This code is not empty only if the CDM entity was imported from a CDMfr file.
     * @return the CDM code. Can be null;
     */
    public String getCdmCode();
    
    /**
     * Set the CDM code.
     * This code should be setted only when the CDM entity was imported from a CDMfr file.
     * @param cdmCode the CDM code to set
     */
    public void setCdmCode(String cdmCode);
}
