/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.content.code;

import java.util.Optional;

import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.orgunit.OrgUnit;

/**
 * Implementation of {@link DisplayCodeProvider} that returns the Ametys code of the program item
 */
public class AmetysDisplayCodeProvider extends AbstractStaticProgramItemDisplayCodeProvider
{
    /** Id of the default display code provider */
    public static final String ID = "odf-ametys-code";
    
    public boolean supports(Content content)
    {
        return true;
    }
    
    public Optional<String> getDisplayCode(Content content)
    {
        if (content instanceof ProgramItem programItem)
        {
            return Optional.ofNullable(programItem.getCode());
        }
        else if (content instanceof OrgUnit orgUnit)
        {
            return  Optional.ofNullable(orgUnit.getUAICode());
        }
        else if (content instanceof CoursePart coursePart)
        {
            return  Optional.ofNullable(coursePart.getCode());
        }
        else
        {
            return  Optional.empty();
        }
    }
}
