/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.coursepart.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.JoinQuery;
import org.ametys.cms.search.query.NotQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.Query.Operator;
import org.ametys.cms.search.query.StringQuery;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.search.ShareableCourseCriterionDefinition;
import org.ametys.odf.coursepart.CoursePart;

/**
 * UI criteria for shareable course part
 */
public class ShareableCoursePartCriterionDefinition extends ShareableCourseCriterionDefinition
{
    @Override
    protected Query _getShareableQuery(Object value, Operator customOperator, Map<String, Object> allValues, String language, Map<String, Object> contextualParameters)
    {
        List<Query> queries = new ArrayList<>();
        
        // Shareable course must be validated
        queries.add(_getValidatedShareableCourseQuery());
        
        if (contextualParameters.containsKey("courseId"))
        {
            String courseId = (String) contextualParameters.get("courseId");
            if (StringUtils.isNotBlank(courseId))
            {
                ProgramItem course = _resolver.resolveById(courseId);
                queries.addAll(_getShareableFieldQueries(course));
            }
        }
        
        AndQuery query = queries.stream()
                .filter(q -> q != null)
                .collect(AndQuery.collector());
            
        return new OrQuery(
            new JoinQuery(query, CoursePart.COURSE_HOLDER), // returns the course parts whose parent course matches the shareable field values of the current course
            new NotQuery(new StringQuery(CoursePart.COURSE_HOLDER)) // A course part with no holder is considered as shareable (no shareable fields could matched)
        );
    }
}
