/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.enumeration;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * Month enumerator: 1 for January, 12 for December.
 */
public class MonthEnumerator implements Enumerator<String>, Serviceable, Component
{
    /** Avalon Role */
    public static final String ROLE = MonthEnumerator.class.getName();
    
    private static final String __CATALOGUE = "plugin.odf";
    private static final Map<String, I18nizableText> __MONTHS;
    
    static
    {
        __MONTHS = new LinkedHashMap<>(3);
        __MONTHS.put("1", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_JANUARY"));
        __MONTHS.put("2", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_FEBRUARY"));
        __MONTHS.put("3", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_MARCH"));
        __MONTHS.put("4", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_APRIL"));
        __MONTHS.put("5", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_MAY"));
        __MONTHS.put("6", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_JUNE"));
        __MONTHS.put("7", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_JULY"));
        __MONTHS.put("8", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_AUGUST"));
        __MONTHS.put("9", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_SEPTEMBER"));
        __MONTHS.put("10", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_OCTOBER"));
        __MONTHS.put("11", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_NOVEMBER"));
        __MONTHS.put("12", new I18nizableText(__CATALOGUE, "PLUGINS_ODF_MONTH_ENUMERATOR_DECEMBER"));
    }

    /**
     * i18n utils
     */
    protected I18nUtils _i18nUtils;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _i18nUtils = (I18nUtils) manager.lookup(I18nUtils.ROLE);
    }
    
    @Override
    public Map<String, I18nizableText> getEntries() throws Exception
    {
        return __MONTHS;
    }

    @Override
    public I18nizableText getEntry(String value)
    {
        return __MONTHS.get(value);
    }
    
    /**
     * Get the translated label for the given code
     * @param code The code to retrieve
     * @param language The language for the translation
     * @return The translated label or an empty string
     */
    public String getLabel(String code, String language)
    {
        return Optional.ofNullable(code)
                .map(this::getEntry)
                .map(key -> _i18nUtils.translate(key, language))
                .orElse(StringUtils.EMPTY);
    }
}
