/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.enumeration;

import java.io.IOException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectIterable;

/**
 * SAX all items of a constant.
 */
public class OdfReferenceTableGenerator extends ServiceableGenerator
{
    /** The enumeration helper for ODF */
    protected OdfReferenceTableHelper _refTableHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _refTableHelper = (OdfReferenceTableHelper) smanager.lookup(OdfReferenceTableHelper.ROLE);
    }

    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        String cTypeId = parameters.getParameter("content-type", StringUtils.EMPTY);
        String lang = parameters.getParameter("lang", StringUtils.EMPTY);
        
        contentHandler.startDocument();
        
        _refTableHelper.saxItems(contentHandler, cTypeId, lang);
        
        contentHandler.endDocument();
    }
    
    /**
     * SAX items
     * @param items the items
     * @param depth the depth
     * @throws SAXException if an error occurred while SAXing
     */
    protected void _saxItems (AmetysObjectIterable<Content> items, int depth) throws SAXException
    {
        for (Content item : items)
        {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", item.getId());
            attrs.addCDATAAttribute("code", item.getValue(OdfReferenceTableEntry.CODE, false, StringUtils.EMPTY));
            XMLUtils.createElement(contentHandler, "item", item.getTitle());
            
            // FIXME sub-items ?
        }
    }
}
