/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.export.indesign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.cocoon.JSonReader;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Get the indesign stylesheet names and their labels
 *
 */
public class GetIndesignFilesAction extends ServiceableAction implements Configurable
{
    /** The helper for indesign transformations */
    private IndesignTransformationHelper _indesignTransformationHelper;
    
    private boolean _global;
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        _global = "true".equals(configuration.getChild("global").getValue("true"));
    }
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _indesignTransformationHelper = (IndesignTransformationHelper) serviceManager.lookup(IndesignTransformationHelper.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Map<String, Object> result = new HashMap<>();
        
        List<Map<String, Object>> files = new ArrayList<>();
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        Map<String, I18nizableText> xsltFiles = _global ? _indesignTransformationHelper.getIndesignGlobalXslt() : _indesignTransformationHelper.getIndesignXslt();
        
        for (String fileName : xsltFiles.keySet())
        {
            Map<String, Object> file = new HashMap<>();
            file.put("name", fileName);
            file.put("label", xsltFiles.get(fileName));
            files.add(file);
        }
        
        result.put("files", files);
        
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

}
