/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.lheo;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * Helper to get abstract programs to export for LHEO
 * Can be overridden in projects to have specific query for abstract programs
 */
public class LHEOQueryManager extends AbstractLogEnabled implements Serviceable, Component
{
    /** The Avalon role */
    public static final String ROLE = LHEOQueryManager.class.getName();
    
    /** The catalogs manager */
    protected CatalogsManager _catalogsManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _catalogsManager = (CatalogsManager) smanager.lookup(CatalogsManager.ROLE);
    }
    
    /**
     * Get abstract programs to export in LHEO
     * @param catalog the catalog
     * @param lang the lang
     * @param additionalParameters the additional parameters
     * @return the list of abstract programs
     */
    public List<AbstractProgram> getAbstractProgramsToExport(String catalog, String lang, Map<String, Object> additionalParameters)
    {
        // Get only programs for default implementation for legacy purpose
        AmetysObjectIterable<Program> programs = _catalogsManager.getPrograms(catalog, lang);
        return programs.stream().collect(Collectors.toList());
    }
}
