/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.program;

import org.ametys.cms.model.properties.AbstractIndexableStaticProperty;
import org.ametys.cms.repository.Content;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * Property of the type of degree for a program
 */
public class DegreeTypeProperty extends AbstractIndexableStaticProperty<Long, Long, Content>
{
    private static final String DEGREE_TYPE_NATIONAL = "NATIONAL";
    private static final String DEGREE_TYPE_UNIVERSITY = "UNIVERSITY";
    
    public Object getValue(Content content)
    {
        if (content instanceof Program)
        {
            switch (content.getValue("degree/type", false, ""))
            {
                case DEGREE_TYPE_NATIONAL:
                    return 10L;
                case DEGREE_TYPE_UNIVERSITY:
                    return 20L;
                default:
                    return Long.MAX_VALUE;
            }
        }
        return null;
    }

    @Override
    protected String getTypeId()
    {
        return ModelItemTypeConstants.LONG_TYPE_ID;
    }
}
