/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.tree;

import java.util.Map;

import org.ametys.cms.repository.Content;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.courselist.CourseList.ChoiceType;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * {@link ODFTreeIndicator} to indicate the type of a {@link CourseList}
 */
public class CourseListTypeIndicator extends AbstractStaticODFTreeIndicator
{
    public IndicatorData getIndicatorData(Content content)
    {
        if (content instanceof CourseList courseList)
        {
            ChoiceType type = courseList.getType();
            switch (type)
            {
                case CHOICE:
                    return new IndicatorData(new I18nizableText("plugin.odf", "PLUGINS_ODF_CONTENTS_TREE_INDICATORS_COURSELIST_CHOICE"), null, "ametysicon-arrow-up-right-curve", Map.of());
                case OPTIONAL:
                    return new IndicatorData(new I18nizableText("plugin.odf", "PLUGINS_ODF_CONTENTS_TREE_INDICATORS_COURSELIST_OPTIONAL"), null, "ametysicon-sign-question", Map.of());
                default:
                    break;
            }
        }
        return null;
    }
}
