/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow;

import java.util.List;

import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

import org.ametys.cms.repository.Content;
import org.ametys.cms.workflow.ContentCheckRightsCondition;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.rights.ODFRightHelper;
import org.ametys.odf.rights.ODFRightHelper.ContextualizedContent;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Check that user is allowed for current educational path as producer of the program item.
 */
public class ContextualizedContentCheckRightsCondition extends ContentCheckRightsCondition implements Contextualizable
{
    private Context _context;

    public void contextualize(Context context) throws ContextException
    {
        _context = context;
    }
    
    @Override
    protected boolean hasRight(UserIdentity user, String right, Object context)
    {
        if (context instanceof Content content)
        {
            Request request = ContextHelper.getRequest(_context);
            @SuppressWarnings("unchecked")
            List<EducationalPath> paths = (List<EducationalPath>) request.getAttribute(ODFRightHelper.REQUEST_ATTR_EDUCATIONAL_PATHS);
            
            if (paths != null)
            {
                for (EducationalPath path : paths)
                {
                    if (super.hasRight(user, right, new ContextualizedContent(content, path)))
                    {
                        return true;
                    }
                }
            }
        }
        
        return false;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_WORKFLOW_CONTEXTUALIZABLE_CONTENT_CHECK_RIGHTS_CONDITION_LABEL");
    }
    
    @Override
    protected I18nizableText _getSingleConditionDescriptionKey(List<String> parameters)
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_WORKFLOW_CONTEXTUALIZABLE_CONTENT_CHECK_RIGHTS_CONDITION_DESCRIPTION", parameters);
    }
}
