<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:param name="alphaOrder">false</xsl:param>
    
    <xsl:template match="items">
        <items>
            <xsl:copy-of select="@*"/>
            
            <xsl:choose>
                <xsl:when test="$alphaOrder = 'true'">
                    <xsl:apply-templates select="item">
                        <xsl:sort select="."/>
                    </xsl:apply-templates>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="item">
                        <xsl:sort select="@order" data-type="number"/>
                        <xsl:sort select="."/>
                    </xsl:apply-templates>
                </xsl:otherwise>
            </xsl:choose>
        </items>
    </xsl:template>
    
    <xsl:template match="item">
        <item>
            <xsl:copy-of select="@*"/>
            <xsl:copy-of select="node()"/>
        </item>
    </xsl:template>
    
</xsl:stylesheet>
