/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.odf.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.cocoon.JSonReader;

/**
 * Get the catalogs
 *
 */
public class GetCatalogsAction extends ServiceableAction
{
    /** The catalog manager */
    private CatalogsManager _catalogsManager;
    
    /** The catalog DAO */
    private CatalogDAO _catalogDAO;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _catalogsManager = (CatalogsManager) serviceManager.lookup(CatalogsManager.ROLE);
        _catalogDAO = (CatalogDAO) serviceManager.lookup(CatalogDAO.ROLE);
    }
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Map<String, Object> result = new HashMap<>();
        
        List<Map<String, Object>> catalogsProperties = new ArrayList<>();
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        List<Catalog> catalogs = _catalogsManager.getCatalogs();
        
        for (Catalog catalog : catalogs)
        {
            catalogsProperties.add(_catalogDAO.getCatalogProperties(catalog));
        }
        
        result.put("catalogs", catalogsProperties);
        
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

}
