/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton class to edit shareable course fields
 * @private
 */
Ext.define('Ametys.plugins.odf.course.actions.EditShareableCourseAction', {
    singleton: true,
    
    /**
	 * Action function to be called by the controller.
	 * Will open the dialog box to edit shareable course fields
	 * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
	 */
	act: function (controller)
	{
        var config = controller.initialConfig;
        var workflowName = config.workflowName || "course";
        var viewName = config.viewName || "shareable";
        var editWorkflowActionId = config.editWorkflowActionId || 2;
        
        var target = controller.getMatchingTargets()[0];
		if (target != null)
		{
			var contentId = target.getParameters().id;
			Ametys.cms.content.ContentDAO.getContent(contentId, Ext.bind(this._editShareableCourse, this, [workflowName, viewName, editWorkflowActionId], 1));
		}
	},
	
	/**
	 * Open the dialog box to edit shareable course fields
	 * @param {Ametys.cms.content.Content} content The content to modify
     * @param {String} workflowName The workflow name
	 * @param {String} viewName The view name
	 * @param {String} editWorkflowActionId The id of the edit function for shareable course
	 */
	_editShareableCourse: function(content, workflowName, viewName, editWorkflowActionId)
	{
		var openParams = {
                content: content,
                editWorkflowActionId: editWorkflowActionId,
                workflowName: workflowName,
                viewName: viewName
            }
		
		Ametys.cms.uihelper.EditContent.open(openParams, null, this);
	}
	
});