/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.oai;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Abstract implementation of a OAI-PMH set with a configurable name and description
 */
public abstract class AbstractOaiSet implements OaiSet, Configurable, Component, Serviceable
{
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;
    
    private I18nizableText _name;
    private I18nizableText _description;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        _name = _getI18nizableConfiguration(configuration, "name", "");
        _description = _getI18nizableConfiguration(configuration, "description", null);
    }
    
    private I18nizableText _getI18nizableConfiguration(Configuration configuration, String configurationName, String defaultValue)
    {
        boolean isValueI18n = configuration.getChild(configurationName).getAttributeAsBoolean("i18n", false);
        String value =  configuration.getChild(configurationName).getValue(defaultValue);

        if (value == null)
        {
            return null;
        }
        else if (isValueI18n)
        {
            String valueI18nPlugin = configuration.getChild(configurationName).getAttribute("plugin", "odf");
            return new I18nizableText("plugin." + valueI18nPlugin, value);
        }
        else
        {
            return new I18nizableText(value);
        }
    }

    public I18nizableText getName()
    {
        return _name;
    }

    public I18nizableText getDescription()
    {
        return _description;
    }
}
