/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.orgunit;

import java.util.HashSet;
import java.util.Set;

import org.ametys.cms.model.properties.AbstractIndexableContentProperty;
import org.ametys.cms.model.properties.Property;
import org.ametys.cms.repository.ModifiableContent;

/**
 * {@link Property} to get all orgUnit ancestors id in one field.
 */
public class OrgUnitAncestorProperty extends AbstractIndexableContentProperty<OrgUnit>
{
    @Override
    protected Set< ? extends ModifiableContent> _getLinkedContents(OrgUnit orgUnit)
    {
        Set<OrgUnit> values = new HashSet<>();
        values.add(orgUnit);
        
        OrgUnit ancestor = orgUnit.getParentOrgUnit();
        while (ancestor != null)
        {
            values.add(ancestor);
            ancestor = ancestor.getParentOrgUnit();
        }
        
        return values;
    }
    
    @Override
    public boolean isMultiple()
    {
        return true;
    }
    
    public String getContentTypeId()
    {
        return OrgUnitFactory.ORGUNIT_CONTENT_TYPE;
    }
    
    @Override
    public String getDefaultCriterionWidget()
    {
        return "edition.select-orgunit";
    }
}
