/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.bean;

import org.apache.commons.lang3.StringUtils;

/**
 * Website object
 */
public abstract class AbstractExternalAddress
{
    private String _url;
    private String _label;
    
    /**
     * Constructor
     * @param url URL of the website
     * @param label Label of the website
     */
    public AbstractExternalAddress(String url, String label)
    {
        _url = url;
        _label = label;
    }

    /**
     * Getter for the URL
     * @return the URL
     */
    public String getUrl()
    {
        return _url;
    }

    /**
     * Setter for the URL
     * @param url the URL
     */
    public void setUrl(String url)
    {
        _url = url == null ? "" : url;
    }

    /**
     * Getter for the label
     * @return the label
     */
    public String getLabel()
    {
        return _label;
    }

    /**
     * Setter for the label
     * @param label the label
     */
    public void setLabel(String label)
    {
        _label = label == null ? "" : label;
    }
    
    @Override
    public boolean equals(Object obj)
    {
        if (obj == null)
        {
            return false;
        }
        
        if (!(obj instanceof AbstractExternalAddress))
        {
            return false;
        }
        
        AbstractExternalAddress webSite = (AbstractExternalAddress) obj;
        if (!StringUtils.equals(this.getUrl(), webSite.getUrl()) || !StringUtils.equals(this.getLabel(), webSite.getLabel()))
        {
            return false;
        }
        
        return true;
    }
    
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }
}
