/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.person.generators;

import java.io.IOException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.odf.person.Person;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * SAX {@link Person}s
 */
public class PersonGenerator extends ServiceableGenerator
{
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }

    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String[] ids = request.getParameterValues("id");

        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "persons");
        
        for (String id : ids)
        {
            Person person = _resolver.resolveById(id);
            _saxPerson (person);
        }
            
        XMLUtils.endElement(contentHandler, "persons");
        contentHandler.endDocument();
    }
    
    private void _saxPerson(Person person) throws SAXException
    {
        AttributesImpl attr = new AttributesImpl();

        attr.addCDATAAttribute("firstname", person.getGivenName());
        attr.addCDATAAttribute("lastname", person.getLastName());
        attr.addCDATAAttribute("title", person.getTitle());
        attr.addCDATAAttribute("personTitle", person.getPersonTitle());
        attr.addCDATAAttribute("id", person.getId());

        XMLUtils.createElement(contentHandler, "person", attr);
    }
}
