/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


let contents = Repository.query("//element(*, ametys:content)[@ametys-internal:contentType = 'org.ametys.plugins.odf.Content.course']");

let total = contents.getSize();
let handled = 0;
let count = 0;

logger.info(`Start to migrate dataByEducationalPath repeater for ${total} contents`);

contents.forEach(
    content =>
    {
        let contentNode = content.getNode();
        if (contentNode.hasNode("ametys:dataByEducationalPath"))
        {
            Content.migrate( 
                content, 
                [_migrateEducationalPathRepeater], 
                false, /* old version still comptatible */ 
                null, /* no tag */ 
                false, /* verbose */
                true /* synchronize live */
            );
        }
        
        handled++;
        if (handled % 200 == 0)
        {
            logger.info(`${handled}/${total} handled courses`);
        }
    }
);

logger.info(`${count} contents have been updated to migrate dataByEducationalPath repeater`);

function _migrateEducationalPathRepeater(content)
{
    let contentNode = content.getNode();
    if (contentNode.hasNode("ametys:dataByEducationalPath"))
    {
		let repeaterNode = contentNode.getNode("ametys:dataByEducationalPath");
		
		// Browse repeater entries to move mccCooefficient property if exists to new repeater mccCoefficientByEducationalPath 
		let index = 1;          
	    for (let i = 1; i <= repeaterNode.getNodes("ametys:*").getSize(); i++)          
	    {          
	        if (repeaterNode.hasNode("ametys:" + i))          
	        {          
	            let entryNode = repeaterNode.getNode("ametys:" + i);
				     
				if (entryNode.hasProperty("ametys:mccCoefficient"))
				{
					let coefProp = entryNode.getProperty("ametys:mccCoefficient");
					let values = entryNode.getNode("ametys:path").getProperty("ametys:programItemIds").getValues();
					let path = java.lang.reflect.Array.newInstance(java.lang.String, values.length);
                    for (let j = 0; j < values.length; j++)          
	    			{ 
                      	path[j] = values[j].getString();
                    }
				    let coef = coefProp.getDouble();
					coefProp.remove();
					
					let mccRepeater = content.getRepeater("mccCoefficientByEducationalPath", true);
					let mccEntry = mccRepeater.addEntry();
					Repository.helper.setModelAwareValue(mccEntry, "coefficient", coef);
					Repository.helper.setModelAwareValue(mccEntry, "path", org.ametys.odf.data.EducationalPath.of(path));
				}         
	        }          
	    }       
		
		// Move dataByEducationalPath to ectsByEducationalPath
		repeaterNode.getSession().move(repeaterNode.getPath(), contentNode.getPath() + "/ametys:ectsByEducationalPath");
		
        count++;
    }
}