/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the representation of a catalog.
 * @private
 */
Ext.define(
    "Ametys.odf.catalog.Catalog", 
    {
        config: {
            /**
             * @cfg {String} id The unique id of the catalog
             */
            /**
             * @method getId Get the #cfg-id
             * @return {String} The id
             */
            /** @ignore */
            id: null,
            /**
             * @cfg {String} title The title of the catalog
             */
            /**
             * @method getTitle Get the #cfg-title
             * @return {String} The title
             */
            /** @ignore */
            title: null,
            /**
             * @cfg {String} code The code of the catalog
             */
            /**
             * @method getCode Get the #cfg-code
             * @return {String} The code
             */
            /** @ignore */
            code: null,
            /**
             * @cfg {Boolean} isDefault True of the catalog is the default catalog
             */
            /**
             * @method getIsDefault Get the #cfg-isDefault
             * @return {Boolean} The default state
             */
            /** @ignore */
            isDefault: null
        },
        
        
        /**
         * Creates a content instance
         * @param {Object} config See configuration doc.
         */
        constructor: function (config)
        {
            this.initConfig(config);
        },
        
        /**
         * Get the catalog's properties
         * @return {Object} The catalog's properties
         */
        getProperties: function (initialProperty)
        {
            initialProperty = initialProperty || {};
            
            return Ext.apply ({
                    id: this._id,
                    title: this._title,
                    isDefault: this._isDefault,
                    code: this._code
                }, initialProperty
            );
        }
    }
);

