/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

 /**
  * The TreeGrid for TreeGridTools
  * @private
  */
Ext.define('Ametys.plugins.odf.tree.AbstractODFTreeGridPanel', {
    extend: 'Ametys.plugins.odf.tree.ODFContentsTreePanel',
    
    constructor: function(config)
    {
        this._activeIndicators = config.activeIndicators;
        
        config.enableIndicatorMenu = false;
        
        this.callParent(arguments);
    },
    
    applyState: function (state)
    {
        state.activeIndicators = this.getInitialConfig('activeIndicators');
        this.callParent(arguments);
    },    
    
    _getToolBarConfig: function(config)
    {
        let toolbarCfg = this.callParent(arguments);
        for (let cfg of toolbarCfg.items)
        {
            if (cfg.xtype == 'tbspacer')
            {
                delete cfg.flex;
                cfg.width = '16';
            }
        }
        return toolbarCfg;
    }
});
