/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.cdmfr;

import java.util.Map;

import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.XMLConsumer;

import org.ametys.cms.data.LocalMediaObjectHandler;
import org.ametys.cms.transformation.AbstractEnhancementTransformer;
import org.ametys.runtime.model.type.DataContext;

/**
 * Cocoon {@link Transformer} to trnasform docboock to CDM-Fr
 */
public class Docbook2CDMFrTransformer extends AbstractEnhancementTransformer implements Contextualizable
{
    /** The avalon context */
    protected Context _context;
    
    public void contextualize(Context context) throws ContextException
    {
        _context = context;
    }
    
    @Override
    public void setConsumer(XMLConsumer consumer)
    {
        Map objectModel = ContextHelper.getObjectModel(_context);
        Map parentContextParameters = (Map) objectModel.get(ObjectModelHelper.PARENT_CONTEXT);
        DataContext dataContext = (DataContext) parentContextParameters.get("dataContext");
        
        _contentHandler = new LocalMediaObjectHandler(consumer, dataContext);
        _lexicalHandler = consumer;
    }
}
