/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.contenttype;

import org.apache.avalon.framework.component.Component;

import org.ametys.cms.model.restrictions.RestrictedModelItem;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * Manager for odf content type attribute
 */
public class ODFContentTypeAttributeManager extends AbstractLogEnabled implements Component
{
    /** The avalon role */
    public static final String ROLE = ODFContentTypeAttributeManager.class.getName();
    
    /**
     * Determine whether an attribute can be read at this time.
     * Method called by {@link RestrictedModelItem#canRead(Object)} to do some other checks, depending on the content type
     * @param definition the attribute definition
     * @param content The content where attribute is to be read on. Can be null, on content creation. 
     * @return <code>true</code> if the current user is allowed to read the attribute of this content.
     * @throws AmetysRepositoryException if an error occurs while accessing the content.
     */
    public boolean canRead(Content content, RestrictedModelItem<Content> definition) throws AmetysRepositoryException
    {
        return true;
    }
    
    /**
     * Determine whether an attribute can be written at this time.
     * Method called by {@link RestrictedModelItem#canWrite(Object)} to do some other checks, depending on the content type
     * @param definition the attribute definition
     * @param content The content where attribute is to be written on. Can be null, on content creation. 
     * @return <code>true</code> if the current user is allowed to write the attribute of this content.
     * @throws AmetysRepositoryException if an error occurs while accessing the content.
     */
    public boolean canWrite(Content content, RestrictedModelItem<Content> definition) throws AmetysRepositoryException
    {
        return canRead(content, definition);
    }
}
