/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow.copy;

import java.util.Map;
import java.util.Set;

import org.ametys.cms.repository.Content;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.courselist.CourseListContainer;
import org.ametys.odf.courselist.CourseListFactory;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.workflow.CreateCourseListFunction;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * OSWorkflow function to create a course list by copy of another
 */
public class CreateCourseListByCopyFunction extends AbstractCreateProgramItemByCopyFunction
{
    @Override
    protected String _getContentNamePrefix()
    {
        return CreateCourseListFunction.CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return CourseListFactory.COURSE_LIST_NODETYPE;
    }

    @Override
    protected Set<String> _getChildrenReferencesName()
    {
        return Set.of(CourseList.CHILD_COURSES);
    }

    @Override
    protected boolean _isCompatibleParent(Content parent)
    {
        return parent instanceof CourseListContainer;
    }

    @Override
    protected String _getParentAttributeName(Content parent)
    {
        if (parent instanceof Course)
        {
            return CourseList.PARENT_COURSES;
        }
        return ProgramPart.PARENT_PROGRAM_PARTS;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_COURSE_LIST_BY_COPY_FUNCTION_LABEL");
    }
}
