/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let steps = Repository.query("//element(*, oswf:entry)[@oswf:workflowName = 'course']/element(*, oswf:step)[@oswf:actionId = 222]", false)

let handled = 0;
let total = steps.getSize();

logger.info(`${total} steps to migrate (step with action 222 in course workflows)`);
while (steps.hasNext())
{
    let step = steps.nextNode();
    step.setProperty("oswf:actionId", 225);
    step.save();
    
    handled++;
    if (handled % 500 == 0)
    {
        logger.info(`${handled}/${total} handled steps`);
    }
}
logger.info(`${handled} steps have been migrated`);

