<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="cms">

	<xsl:import href="container.xsl"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-css-class-name">container view-abstract</xsl:variable>     
    <xsl:variable name="common-content-name">container</xsl:variable>
	
     <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-content-head-title">
        <xsl:call-template name="common-content-head-title-content"/>
    </xsl:template> 

    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-content-body-title"/>
    
	<xsl:template name="common-content-body-content">
		<p class="content-link">
        	<xsl:if test="normalize-space(metadata/code) != ''">
        		<span class="element-name"><i18n:text i18n:key="CONTENT_CONTAINER_CODE"/></span>
            	<xsl:text> </xsl:text>
            	<span class="element-value"><xsl:value-of select="metadata/code"/></span>
        	</xsl:if>
        	<xsl:if test="normalize-space(metadata/ects) != ''">
        		<span class="element-name"><i18n:text i18n:key="CONTENT_CONTAINER_ECTS"/></span>
    	        <xsl:text> </xsl:text>
    	        <span class="element-value"><xsl:value-of select="metadata/ects"/></span>
	        </xsl:if>
        </p>    
    </xsl:template>    
	
</xsl:stylesheet>