<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:cms="http://ametys.org/cms/3.0"
                xmlns:func="http://exslt.org/functions"
                xmlns:dyn="http://exslt.org/dynamic"
                exclude-result-prefixes="i18n xalan resolver cms func dyn">
    
    <xsl:param name="currentParentId"/>
    
    <xsl:decimal-format grouping-separator=" " decimal-separator="," />
    
    <xsl:template match="/view">
        <xml>
            <title>
                <xsl:value-of select="/view/content/metadata/nature/code"/>
                <xsl:text> | </xsl:text>
                <xsl:value-of select="format-number(/view/content/metadata/nbHours, '#,##')"/><i18n:text i18n:catalogue="plugin.core-ui" i18n:key="PLUGINS_CORE_UI_DURATION_FORMAT_HOURS"/>
            </title>
            <display><xsl:apply-templates select="contentType/fieldset|contentType/metadata" mode="display"/></display>
        </xml>
    </xsl:template>
    
    <xsl:template match="fieldset" mode="display">
        
        <xsl:variable name="self" select="."/>
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <p><strong><xsl:value-of select="label"/></strong></p>
            
            <div class="sub">
                <xsl:apply-templates select="fieldset|metadata" mode="display"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="medatata[@type='composite']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value/*">
            <p><strong><xsl:value-of select="label"/></strong></p>
            <div class="sub">
                <xsl:apply-templates select="medatata" mode="display"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type='repeater']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/@entryCount != '0'">
            <p><strong><xsl:value-of select="label"/></strong></p>
                        
            <xsl:variable name="repeaterDef" select="."/>
                
            <xsl:for-each select="$value/entry">
                <div class="sub">
                    <p class="entry"><i18n:text i18n:catalogue="plugin.cms" i18n:key='UITOOL_DETAILS_CONTENT_REPEATER_ENTRY'/><xsl:text> </xsl:text><xsl:value-of select="@name"/></p>
                    <div class="subsub">
                        <xsl:for-each select="node()">
                            <xsl:variable name="subname" select="local-name()"/>
                            <xsl:apply-templates select="$repeaterDef/metadata[@name = $subname]" mode="display">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </div>
                </div>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <p>
                <strong><xsl:value-of select="label"/></strong><br/>
                
                <xsl:variable name="self" select="."/>
                
                <xsl:for-each select="$value">
                    <xsl:variable name="name" select="local-name()"/>
                    <xsl:apply-templates select="$self" mode="value">
                        <xsl:with-param name="value" select="."/>
                    </xsl:apply-templates>
                    <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
                </xsl:for-each>
            </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type='content']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="contentId" select="$value/@id" />
        <xsl:if test="$contentId != ''">
            <xsl:choose>
                <xsl:when test="ametys:isReferenceTableContent($contentId)">
                    <xsl:value-of select="$value/@title"/>
                </xsl:when>
                <xsl:otherwise>
                    <a href="{resolver:resolve('content', $contentId)}">
                        <xsl:value-of select="$value/@title"/>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type='date']" mode="value">
        <xsl:param name="value"/>
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="long" value="{$value}"/>
    </xsl:template>
    
    <xsl:template match="metadata[@type='datetime']" mode="value">
        <xsl:param name="value"/>
        <i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="long" value="{$value}"/>
    </xsl:template>
    
    <xsl:template match="metadata[@type='reference']" mode="value">
        <xsl:param name="value"/>
        
        <a>
            <xsl:attribute name="href"><xsl:value-of select="$value"/></xsl:attribute>
            <xsl:value-of select="$value"/>
        </a>
    </xsl:template>
        
    <xsl:template match="metadata[@type='file']" mode="value">
        <xsl:param name="value"/>
        
        <a href="{resolver:resolve($value/@type, $value/@path, 'true')}" title="{$value/@filename} ({$value/@size})">
            <xsl:value-of select="$value/@filename"/>
        </a>
    </xsl:template>
    
    <xsl:template match="metadata[@type='geocode']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="concat(substring-before($value/@latitude, '.'), '.', substring(substring-after($value/@latitude, '.'), 1, 4))"/><xsl:text>°N , </xsl:text><xsl:value-of select="concat(substring-before($value/@longitude, '.'), '.', substring(substring-after($value/@longitude, '.'), 1, 4))"/><xsl:text>°E</xsl:text>
    </xsl:template>
    
    <xsl:template match="metadata[@type='boolean']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:choose>
            <xsl:when test="$value = 'true'"><i18n:text i18n:catalogue="plugin.cms" i18n:key="UITOOL_DETAILS_BOOLEAN_TRUE"/></xsl:when>
            <xsl:otherwise><i18n:text i18n:catalogue="plugin.cms" i18n:key="UITOOL_DETAILS_BOOLEAN_FALSE"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="metadata" mode="value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value"/>
    </xsl:template>
    
    <xsl:template match="*" mode="value">
        <xsl:value-of select="."/>
    </xsl:template>
    
    <!-- +
         | This function tests if a fieldset is not empty, 
         | ie. it is composed at least of a valued metadata or a non-empty fieldset.
         | Be careful, metadata of type 'boolean' are excluded for the test.
         | So if the fieldset has only boolean metadata that are valued, it will be considered as empty.
         | Parameters are:
         | - fieldset: the fieldset node
         | - [prefix]: the xpath of the node holding the values. By default /view/content/metadata/
         + -->
    <func:function name="cms:isNotFieldsetEmpty">
        <xsl:param name="fieldset"/>
        <xsl:param name="prefix">/view/content/metadata/</xsl:param>
        
        <xsl:variable name="xpath">
            <xsl:call-template name="compute-xpath">
                <xsl:with-param name="fieldset" select="$fieldset"/>
                <xsl:with-param name="prefix" select="$prefix"/>
            </xsl:call-template>
        </xsl:variable>
        
        <func:result select="dyn:evaluate($xpath)"/>
    </func:function>
    
    <!-- +
         | This template compute the xpath to be evaluated to test if the fieldset is empty
         | Parameters are:
         | - fieldset: the fieldset node
         | - [prefix]: the xpath of the node holding the values. By default /view/content/metadata/
         + -->
    <xsl:template name="compute-xpath">
        <xsl:param name="fieldset"/>
        <xsl:param name="prefix">/view/content/metadata/</xsl:param>
        
        <xsl:for-each select="$fieldset/fieldset|$fieldset/metadata[@type != 'boolean']">
            <xsl:if test="position() != 1"> or </xsl:if>
            <xsl:choose>
                <xsl:when test="@type = 'repeater'"><xsl:value-of select="concat($prefix, @name)"/>[not(@entryCount) or @entryCount != '0']</xsl:when>
                <xsl:when test="@type = 'composite'">
                    <xsl:call-template name="compute-xpath">
                        <xsl:with-param name="fieldset" select="."/>
                        <xsl:with-param name="prefix" select="concat($prefix, @name)"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="local-name() = 'fieldset'">
                    <xsl:call-template name="compute-xpath">
                        <xsl:with-param name="fieldset" select="."/>
                        <xsl:with-param name="prefix" select="$prefix"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="concat($prefix, @name)"/></xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>

    