/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.lheo;

import java.io.IOException;
import java.util.Collections;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.xml.sax.SAXException;

import org.ametys.odf.program.AbstractProgram;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * Generates entity to LHEO
 */
public class ExportToLHEOGenerator extends ServiceableGenerator
{
    /** The ametys object resolver */
    protected AmetysObjectResolver _resolver;
    
    /** The export LHEO manager */
    protected ExportToLHEOManager _exportLHEOManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
        _exportLHEOManager = (ExportToLHEOManager) smanager.lookup(ExportToLHEOManager.ROLE);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);

        // Add the program to the request
        String programId = request.getParameter("id");
        AbstractProgram program = _resolver.resolveById(programId);
        
        // Configure the response header
        Response response = ObjectModelHelper.getResponse(objectModel);
        response.setHeader("Content-Disposition", "attachment; filename=\"LHEO_" + program.getCode() + ".xml" + "\"");
        
        _exportLHEOManager.saxLHEO(contentHandler, Collections.singletonList(program));
    }
}
