/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.observation;

import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.odf.cdmfr.SendCDMfrProcessor;
import org.ametys.odf.program.Program;

/**
 * Observer to send the CDMFR file when a odf content is validated
 */
public class SendCDMFRObserver extends AbstractCDMFRObserver
{
    /** The send CDM-fr processor */
    protected SendCDMfrProcessor _sendCDMfrProcessor;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _sendCDMfrProcessor = (SendCDMfrProcessor) manager.lookup(SendCDMfrProcessor.ROLE);
    }
    
    @Override
    protected boolean isActive()
    {
        return _sendCDMfrProcessor.isActive();
    }

    @Override
    protected void doObserve(Set<Program> programs)
    {
        _sendCDMfrProcessor.processPrograms(programs);
    }
}
