/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.observation.skill;

import java.util.Map;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;

/**
 * Observer to store the skills of a content before modification.
 * When the deleted content is a Program, keep its "skills" in the request to be able to compare them after modification
 * When the deleted content is a Macro skill, keep its "microSkills" in the request to be able to compare them after modification
 */
public abstract class AbstractContentSkillStep1Observer extends AbstractSkillsStepObserver
{
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        Content content = (Content) event.getArguments().get(ObservationConstants.ARGS_CONTENT);
        // When still modifying the content, save the skills in the request in order to be able to compare them later
        ContentValue[] previousSkillsContentValue = _getSkills(content);
            
        // Save the skills before modification in the request
        _setRequestAttribute("previousSkills", content.getId(), previousSkillsContentValue);
    }
}
