/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton class to remove a referenced content from its parent
 * @private
 */
Ext.define('Ametys.plugins.odf.content.RemoveContentFromParent', {
    singleton: true,
    
    /**
	 * This action removes a referenced content from its parent in the current selection.
	 * The message bus target must have an additionnal parameter "parentNode".
     * The edit workflow action id depends on content type of selected content
	 */
    act: function (controller)
    {
        var target = controller.getMatchingTargets()[0];
        
        if (target != null && target.getParameters().parentNode)
        {
            var me = this;
            var editWorkflowActionId = controller.getInitialConfig("editWorkflowActionId") || 2;
            
            // Check if removed content is referenced in education paths with its parent
            // Do remove if every is fine or the user confirm the removal
            Ametys.plugins.cms.relations.SetContentAttributeRelationHandler.getEducationalPathReferences([],  [{
                            referencingAttributePath: target.getParameters().parentMetadataPath,
                            contentId: target.getParameters().parentNode,
                            valueToRemove: target.getParameters().id
                        }], 
                        Ametys.plugins.contentstree.RemoveFromCurrentSelectionButtonController.remove, 
                        [target, editWorkflowActionId], 
                        this);
        }
    }
});