/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
 * This class is the data model for an abstract progam displayed in the dashboard with changed values.
 * @private
 */
Ext.define('Ametys.plugins.odf.dashboard.AbstractProgramDashboardTool.AbstractProgramEntry', {
	extend: 'Ext.data.Model',
	
	fields: [
		{name: 'id', mapping: '@id'},
		{name: 'name', mapping: '@name'},
		{name: 'language', mapping: '@language'},
		{name: 'language-image', mapping: '@language-image'},
		{name: 'icon', mapping: '@smallIcon'},
		{name: 'title', mapping: '@title', type: 'string'},
        {name: 'code', mapping: 'code', type: 'string'},
		{name: 'displayCode', mapping: 'displayCode', type: 'string'},
        {name: 'catalog', mapping: 'catalog', type: 'string'},
		{name: 'lastModified', mapping: '@lastModified'},
		{name: 'contributor', mapping: '@author'},
		{name: 'workflow-icon-small', mapping: 'workflow-icon-small'},
		{name: 'workflow-step', mapping: 'workflow-step'},
		{name: 'attribute-changes-json', mapping: 'attribute-changes', defaultValue: '[]'},
		{name: 'attribute-changes', calculate: function(data) {
            return JSON.parse(data['attribute-changes-json']);
        }},
		{name: 'important-attribute-changes', calculate: function(data) {
            var changes = data['attribute-changes'];
            return changes
                    .filter(function(change) { return change.isImportant; });
        }}
	]
});
