/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf;

import java.util.List;

import org.ametys.odf.cdmfr.CDMEntity;
import org.ametys.odf.program.Program;
import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * This interface represent a ODF content which is part of a program
 *
 */
public interface ProgramItem extends CDMEntity
{
    /** {@link Program} content type */
    public static final String PROGRAM_ITEM_CONTENT_TYPE = "org.ametys.plugins.odf.Content.programItem";
    
    /** The attribute holding the catalog */
    public static final String CATALOG = "catalog";
    
    /** The attribute holding the code */
    public static final String CODE = "code";
    
    /** The attribute holding the publishable state */
    public static final String PUBLISHABLE = "publishable";
    
    /** The attribute holding the repeater of educational booklets */
    public static final String EDUCATIONAL_BOOKLETS = "educational-booklets";
    
    /** Constants for attribute 'orgUnits' */
    public static final String ORG_UNITS_REFERENCES = "orgUnit";
    
    /** Constants for shared property */
    public static final String SHARED_PROPERTY = "isShared";
    
    /**
     * Get the catalog of this content
     * @return the name of catalog or null if not set
     */
    public String getCatalog();
    
    /**
     * Set the catalog
     * @param name the name of catalog to set
     * @throws AmetysRepositoryException if an error occurred
     */
    public void setCatalog(String name) throws AmetysRepositoryException;
    
    /**
     * Get the unique Ametys code of the {@link ProgramItem}
     * @return the unique Ametys code
     */
    public String getCode();
    
    /**
     * Set the Ametys code
     * @param code the Ametys to set
     * @throws AmetysRepositoryException if an error occurs
     */
    public void setCode(String code) throws AmetysRepositoryException;
    
    /**
     * Get the code to display
     * @return the code to display
     */
    public String getDisplayCode();
    
    /**
     * <code>true</code> if the {@link ProgramItem} is publishable
     * @return <code>true</code> if the {@link ProgramItem} is publishable
     */
    public boolean isPublishable();
    
    /**
     * Set publishable to <code>true</code> to make the {@link ProgramItem} publishable
     * @param isPublishable <code>true</code> to make the {@link ProgramItem} publishable
     */
    public void setPublishable(boolean isPublishable);
    
    /**
     * Return the list of orgUnits binded to this program 
     * @return a list of uuid
    */
    public List<String> getOrgUnits();
    
    
 // --------------------------------------------------------------------------------------//
    // ORGUNITS
    // --------------------------------------------------------------------------------------//

//    /**
//     * Return the list of orgUnits binded to this program 
//     * @return a list of uuid
//     */
//    public List<String> getOrgUnits()
//    {
//        try
//        {
//            return ContentDataHelper.getContentIdsListFromMultipleContentData(this, ORG_UNITS_REFERENCES);
//        }
//        catch (UndefinedItemPathException e)
//        {
//            return Collections.EMPTY_LIST; // this attribute is not part of model
//        }
//    }
}
