/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.orgunit.generators;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.Generator;
import org.xml.sax.SAXException;

import org.ametys.cms.repository.Content;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.orgunit.OrgUnitFactory;
import org.ametys.odf.program.generators.ProgramContentGenerator;

/**
 * {@link Generator} for rendering raw content data for a {@link OrgUnit}.
 */
public class OrgUnitContentGenerator extends ProgramContentGenerator
{
    @Override
    protected void _saxOtherData(Content content, Locale defaultLocale) throws SAXException, ProcessingException, IOException
    {
        super._saxOtherData(content, defaultLocale);
        
        boolean isEdition = parameters.getParameterAsBoolean("isEdition", false);
        if (!isEdition)
        {
            if (content instanceof OrgUnit)
            {
                OrgUnit orgUnit = (OrgUnit) content;
                
                // Contacts
                saxPersons(orgUnit);
                
                // OrgUnits
                saxOrgUnits(orgUnit);
            }
        }
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        request.setAttribute(Content.class.getName(), content);
    }
    
    @Override
    protected Set<String> getLinkedContents(Content content, String linkedContentType)
    {
        // To avoid an infinite loop due to invert relations between org units
        if (content instanceof OrgUnit && linkedContentType.equals(OrgUnitFactory.ORGUNIT_CONTENT_TYPE))
        {
            return new LinkedHashSet<>(((OrgUnit) content).getSubOrgUnits());
        }
        return super.getLinkedContents(content, linkedContentType);
    }
}
