/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.rncp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * Header for the RNCP sheet.
 */
public class SetRNCPHeader extends ServiceableAction
{
    private AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String contentId = request.getParameter("id");

        Content content = _resolver.resolveById(contentId);
        String fileName = "RNCP " + content.getTitle() + ".docx";
        String encodedName = _encodeFileName(fileName);

        Response response = ObjectModelHelper.getResponse(objectModel);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + (encodedName != null ? encodedName : fileName) + "\"" + (encodedName != null ? ";filename*=UTF-8''" + encodedName : ""));
        return EMPTY_MAP;
    }
    
    private String _encodeFileName(String fileName)
    {
        String encodedName = null;
        try
        {
            URI uri = new URI(null, null, fileName, null);
            encodedName = uri.toASCIIString();
            // EXPLORER-358 : Fix for Chrome which does not support comma in filename
            return encodedName.replaceAll(",", "%2C");
        }
        catch (URISyntaxException e)
        {
            // do nothing and send no encoded name
            return null;
        }
    }
}
