/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.schedulable;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.commons.io.FileUtils;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.quartz.JobExecutionContext;

import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.runtime.util.AmetysHomeHelper;

/**
 * Scheduler to check the global validation status on all programs.
 */
public class GlobalValidationSchedulable extends AbstractStaticSchedulable implements Initializable
{
    private SourceResolver _sourceResolver;
    private File _outputFolder;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _sourceResolver = (SourceResolver) smanager.lookup(SourceResolver.ROLE);
    }
    
    public void initialize() throws Exception
    {
        _outputFolder = new File(AmetysHomeHelper.getAmetysHomeData(), "/odf/report");
        FileUtils.forceMkdir(_outputFolder);
    }

    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception
    {
        SitemapSource source = null;
        File reportTmpFile = null;
        
        try
        {
            // Resolve the report pipeline.
            String url = "cocoon://_plugins/odf/global-validation/report.xml";
            source = (SitemapSource) _sourceResolver.resolveURI(url);
            
            // Save the report into a temporary file.
            reportTmpFile = new File(_outputFolder, "global-validation.tmp.xml");
            OutputStream reportTmpOs = new FileOutputStream(reportTmpFile);
            
            SourceUtil.copy(source.getInputStream(), reportTmpOs);
            
            // If all went well until now, copy the temporary file to the real report file.
            File reportFile = new File(_outputFolder, "global-validation.xml");
            FileUtils.copyFile(reportTmpFile, reportFile);
        }
        finally
        {
            // Delete the temporary file.
            if (reportTmpFile != null)
            {
                reportTmpFile.delete();
            }

            if (source != null)
            {
                _sourceResolver.release(source);
            }
        }
    }
}
