/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.source;

import java.io.IOException;

import org.apache.excalibur.source.Source;

/**
 * Component responsible to lookup a {@link Source} for a catalog view
 */
public interface ODFViewSelector
{
    /** Avalon Role */
    public static final String ROLE = ODFViewSelector.class.getName();
    
    /**
     * Get the file source for rendering a content
     * @param pluginName the plugin name
     * @param filePath the path of the file to retrieve
     * @return the file source
     * @throws IOException if the Source cannot be resolved
     */
    public Source getSource(String pluginName, String filePath) throws IOException;
}

