/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.tree;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.repository.Content;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * {@link ODFTreeIndicator} to display code of elements
 *
 */
public class ProgramItemCodeIndicator extends AbstractStaticODFTreeIndicator
{
    public IndicatorData getIndicatorData(Content content)
    {
        String code = null;
        if (content instanceof ProgramItem programItem)
        {
            code = programItem.getDisplayCode();
        }
        else if (content instanceof OrgUnit orgUnit)
        {
            code = orgUnit.getDisplayCode();
        }
        
        if (StringUtils.isNotEmpty(code))
        {
            return new IndicatorData(null, new I18nizableText("plugin.odf", "PLUGINS_ODF_CONTENTS_TREE_INDICATORS_CODE_VALUE", List.of(code)), null, Map.of());
        }
        
        return null;
    }
}
