/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This widget is used for course parts.
 * It allows to select, search, add, edit or remove course parts, depending on its configuration and there it is used. 
 * In a grid or a search form, use the {@link Ametys.odf.widget.SelectCoursePart.Grid} and in a configurable form panel, use the {@link Ametys.odf.widget.SelectCoursePart.CPF}
 */
Ext.define('Ametys.odf.widget.SelectCoursePart', {
    extend: 'Ametys.form.AbstractFieldsWrapper',
    
    canDisplayComparisons: true,

    layout: 'fit',
    style: { backgroundColor: '#fff' },
    
    /**
     * @property {Ext.form.Field} _widget The widget used to represent
     */
    
    onFocusLeave: function()
    {
        this._updateTriggerDialogBoxOpened();
        this.callParent(arguments);
    },
    onFocusEnter: function()
    {
        this._updateTriggerDialogBoxOpened();
        this.callParent(arguments);
    },
    
    _updateTriggerDialogBoxOpened: function() 
    {
        var me = this;
        me.triggerDialogBoxOpened = false;
        
        if (this.items && this.items.isMixedCollection)
        {
            this.items.each(function (item) {
                me.triggerDialogBoxOpened = me.triggerDialogBoxOpened || item.triggerDialogBoxOpened || false;
                if (me.triggerDialogBoxOpened == true)
                {
                    return false;
                }
            });
        }
    },
    
    onAdded: function(container, pos, instanced)
    {
        this.callParent(arguments);
        
        if (!this._widget)
        {
            if (container instanceof Ext.grid.CellEditor || this.searchTool || container.findParentByType('form') != null && container.findParentByType('form').$className == 'Ametys.plugins.cms.search.advanced.AdvancedSearchFormPanel')
            {
                this._widget = Ext.create("Ametys.odf.widget.SelectCoursePart.SelectContent", {
                    allowEdition: container instanceof Ext.grid.CellEditor, // edition not allowed in search form
                    initAndEditWorkflowActionId: 1,
                    workflowName: 'course-part',
                    allowCreation: container instanceof Ext.grid.CellEditor && this.getInitialConfig("allowCreation"), // creation not allowed in search form
                    multiple: this.getInitialConfig("multiple"),
                    contentType: this.getInitialConfig("contentType")
                });
            }
            else
            {
                this._widget = Ext.create("Ametys.odf.widget.SelectCoursePart.Repeater", {
                    workflowName: 'course-part',
                    allowCreation: this.getInitialConfig("allowCreation"),
                    multiple: this.getInitialConfig("multiple"),
                    contentType: this.getInitialConfig("contentType"),
                    contentInfo : this.contentInfo,
                    readOnly: this.disabled || this.readOnly // FIXME RUNTIME-3635 force read-only because with disabled mode the field is unreadable
                });
            }
            
            this.add(this._widget);
        }
    },
    
    getValue: function()
    {
        if (this._widget)
        {
            return this._widget.getValue();
        }
        else
        {
            return this.callParent(arguments);
        }
    },
    
    setValue: function(v)
    {
        this._rawValue = v;
        
        this.callParent(arguments);
        
        if (this._widget)
        {
            this._widget.setValue(v);
        }
    },
    
    /**
      * When used in readonly mode, settting the comparison value will display ins/del tags
      * @param {String} otherValue The value to compare the current value with
      * @param {boolean} base When true, the value to compare is a base version (old) ; when false it is a future value
      */
    setComparisonValue: function(otherValue, base)
    {
         if (base)
         {
             this._baseValue = otherValue || null;
             this._futureValue = undefined;
         }
         else
         {
             this._baseValue = undefined;
             this._futureValue = otherValue || null;
         }
     
        if (this._widget && this._widget.canDisplayComparisons)
        {
            this._widget.setComparisonValue(otherValue, base);
        }
         
         this.setValue(this._rawValue);
    },    
    
    getErrors: function()
    {
        var errors = this.callParent(arguments);

        if (this._widget)
        {
            errors = errors.concat(this._widget.getErrors());
        }

        return errors;
    }
});
