/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a widget to select one or more course parts.<br>
 * This embeds a component with multiple panels to display course parts, buttons, to edit or remove the course part for each panel and general buttons to add or search a course part.<br>
 * Advanced search through a dialog box could be enable. See #cfg-allowSearch.<br>
 * Allow content creation using #cfg-allowCreation.<br>
 * 
 * This widget is used to select course parts in a search tool or to edit course parts in the grid.
 */
Ext.define('Ametys.odf.widget.SelectCoursePart.SelectContent', {
    extend: 'Ametys.cms.form.widget.SelectContent',
    
	modelId: 'search-ui.coursepart',
	
    setValue: function(v)
    {
        this.callParent(arguments);
        
        var parentGrid = this.findParentByType('grid');
        if (parentGrid)
        {
	        var parentContentId = parentGrid.editingPlugin.context.record.getId();
	        
	        // Get the catalog of the current content (needed for creation)
	        Ametys.data.ServerComm.callMethod({
	            role: "org.ametys.odf.catalog.CatalogsManager",
	            methodName: "getContentCatalog",
	            parameters: [parentContentId],
	            callback: {
	                handler: this._setContentCatalogCb,
	                scope: this
	            },
	            waitMessage: false
	        });
        }
    },
    
    /**
     * Set the current content catalog.
     * @param {String} catalogName The catalog name
     * @private
     */
    _setContentCatalogCb: function(catalogName)
    {
        this._contentCatalog = catalogName;
    },
    
    _getAdditionalCreationParameters: function()
    {
        var parentContentId = this.findParentByType('grid').editingPlugin.context.record.getId();
        
        return {
            initAndEditWorkflowActionId: this.initAndEditWorkflowActionId || 1,
            editWorkflowActionId: this.editWorkflowActionId || 2,
            viewName: this.viewForCreation,
            forceMode: 'disabled',
            forceValues: {
                catalog: this._contentCatalog,
                courseHolder: parentContentId
            },
            additionalWorkflowParameters: {
                'org.ametys.odf.workflow.AbstractCreateODFContentFunction$catalog': this._contentCatalog,
                'org.ametys.odf.workflow.AbstractCreateODFContentFunction$courseHolder': parentContentId
            },
            hideTitle: true
        };
    },
    
    _openCreatedContent: function(contentId)
    {
        // Nothing
    }
});
