/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Shareable course status actions
 * @private
 */
Ext.define('Ametys.plugins.odf.course.actions.ShareableCourseStatusButtonActions', {
	singleton: true,
	
	/**
	 * Action function to be called by the controller.
	 * Will change the shareable course status.
	 * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
	 * @param {Boolean} state the state of the button
	 */
	act: function (controller, state)
	{
        Ametys.plugins.cms.content.actions.WorkflowAction.doAction(controller, Ext.bind(this._setStatus, this));
	},
	
	_setStatus: function(controller, comment)
	{
		var contentIds = controller.getContentIds();
        controller.serverCall (
                'setShareableCourseStatus', 
                [contentIds, controller.status, comment], 
                Ext.bind(this._actCB, this), 
                { 
                    refreshing: true,
                    arguments: contentIds
                }
        );
	},
	
	/**
	 * Callback function called after #act is processed.
	 * @param {Object} response The JSON result 
	 * @param {String[]} contentIds The list of content ids to handle  
	 * @private
	 */
	_actCB : function(response, contentIds)
	{
		Ext.create("Ametys.message.Message", {
            type: Ametys.message.Message.MODIFIED,
            parameters: {major: true},
            targets: {
                id: Ametys.message.MessageTarget.CONTENT,
                parameters: {
                    ids: contentIds
                }
            }
        });
	}
});
