/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.course.generators;

import java.io.IOException;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.odf.course.Course;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * SAX a {@link Course}
 *
 */
public class CourseGenerator extends ServiceableGenerator
{
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String id = request.getParameter("id");
        
        contentHandler.startDocument();
        
        Course course = _resolver.resolveById(id);
        _saxCourse(course);
        
        contentHandler.endDocument();
    }
    
    /**
     * SAX a {@link Course}
     * @param course The course to SAX
     * @throws SAXException if an error occurred while SAXing
     */
    protected void _saxCourse(Course course) throws SAXException
    {
        AttributesImpl attr = new AttributesImpl();
        
        attr.addCDATAAttribute("name", course.getName());
        attr.addCDATAAttribute("title", course.getTitle());
        attr.addCDATAAttribute("id", course.getId());
        attr.addCDATAAttribute("hasList", String.valueOf(course.hasCourseLists()));
        
        XMLUtils.createElement(contentHandler, "course", attr);
    }

}
