/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.observation;

import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.ObservationConstants;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.EducationalPathHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * {@link Observer} for observing content deletion in order to remove repeater'entries with a educational path that reference this content
 */
public class RemoveEducationalPathOnContentDeletionObserver extends AbstractLogEnabled implements AsyncObserver, Serviceable
{
    /** The educational path helper */
    protected EducationalPathHelper _educationalPathHelper;

    public void service(ServiceManager smanager) throws ServiceException
    {
        _educationalPathHelper = (EducationalPathHelper) smanager.lookup(EducationalPathHelper.ROLE);
    }

    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_CONTENT_DELETED);
    }

    public int getPriority()
    {
        return MIN_PRIORITY;
    }
    
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        String contentId = (String) event.getArguments().get(ObservationConstants.ARGS_CONTENT_ID);
        if (contentId != null)
        {
            _educationalPathHelper.removeEducationalPathReferences(List.of(contentId));
        }
    }

}
