/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.skill.imports.csv;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.servlet.multipart.Part;

import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightManager.RightResult;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.contentio.csv.ImportCSVFile;
import org.ametys.runtime.authentication.AccessDeniedException;

/**
 * Import skills from an uploaded CSV file.
 */
public class ImportSkillsCSVFile extends ImportCSVFile
{
    /** Avalon Role */
    @SuppressWarnings("hiding")
    public static final String ROLE = ImportSkillsCSVFile.class.getName();
    
    /** The right manager */
    protected RightManager _rightManager;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _rightManager = (RightManager) manager.lookup(RightManager.ROLE);
    }
    /**
     * Import CSV file
     * @implNote Override to change the rights to check for the {@link Callable}
     */
    @Override
    @Callable (rights = Callable.CHECKED_BY_IMPLEMENTATION)
    public Map importCSVFile(String escapingChar, String separatingChar, String contentTypeId, Part part) throws Exception
    {
        if (_rightManager.currentUserHasRight("ODF_Rights_Skills_Handle", null) == RightResult.RIGHT_ALLOW)
        {
            return super.importCSVFile(escapingChar, separatingChar, contentTypeId, part);
        }
        else
        {
            throw new AccessDeniedException("User tried to import skills without sufficient rights");
        }
    }
}
