/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool allows to search courses.
 */
Ext.define('Ametys.plugins.odf.search.ODFContentSearchTool', {
    extend: 'Ametys.plugins.cms.search.ContentSearchTool',
    
    statics:
    {       
        /**
         * Render a multiple metadata in the results grid.
         * @param {Object} value The data value
         * @param {Object} metaData A collection of metadata about the current cell
         * @param {Ext.data.Model} record The record
         * @param {Number} rowIndex The index of the current row
         * @param {Number} colIndex The index of the current column
         * @param {Ext.data.Store} store The data store
         * @param {Ext.view.View} view The current view
         * @param {String} dataIndex The data index of the column
         */
        renderCatalog: function(value, metaData, record, rowIndex, colIndex, store, view, dataIndex)
        {
            var catalog = record.get('properties') ? record.get('properties').catalog : value;
            if (catalog)
            {
                return catalog.label != null ? catalog.label : catalog.value;
            }
            
            return "";
        },
        
        /**
		 * Function to render person's title or name in result grid
		 * @param {Object} value The data value
		 * @param {Object} metaData A collection of metadata about the current cell
		 * @param {Ext.data.Model} record The record
		 */
		renderFullName: function (value, metaData, record)
		{
			var title = '';
			if (record.get('iconSmall'))
			{
				title += '<img src="' + Ametys.CONTEXT_PATH + record.get('iconSmall') + '" style="float:left; margin-right: 5px"/>';
			}
			
            var fullname = [];
            if (!Ext.isEmpty(record.get('lastName')))
            {
                fullname.push(record.get('lastName'));
            }
            if (!Ext.isEmpty(record.get('givenName')))
            {
                fullname.push(record.get('givenName'));
            }
            if (!Ext.isEmpty(record.get('login')))
            {
                fullname.push("(" + record.get('login') + ")");
            }
			return fullname.join(" ");
		},
		
        /**
         * Function to render educational path in result grid
         * @param {Object} value The data value
         * @param {Object} metaData A collection of metadata about the current cell
         * @param {Ext.data.Model} record The record
         */
        renderEducationalPath: Ametys.plugins.cms.search.SearchGridHelper.createRenderContent({
                pluginName: 'odf', 
                url: 'educational-path/get-info', 
                notClickable: true}),
    }
});