/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.catalog;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * {@link Enumerator} for the ODF Catalog
 */
public class CatalogEnumerator implements Enumerator<String>, Serviceable
{
    /** Avalon Role */
    public static final String ROLE = CatalogEnumerator.class.getName();
    
    private CatalogsManager _catalogsManager;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _catalogsManager = (CatalogsManager) manager.lookup(CatalogsManager.ROLE);
    }
    
    @Override
    public Map<String, I18nizableText> getEntries() throws Exception
    {
        Map<String, I18nizableText> result = new HashMap<>();
        
        for (Catalog catalog : _catalogsManager.getCatalogs())
        {
            result.put(catalog.getName(), new I18nizableText(catalog.getTitle()));
        }
        
        return result;
    }
    

    @Override
    public I18nizableText getEntry(String value) throws Exception
    {
        Catalog catalog = _catalogsManager.getCatalog(value);
        
        if (catalog != null)
        {
            return new I18nizableText(catalog.getTitle());
        }
        
        return null;
    }
}
