/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.clientsideelement;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.Callable;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.plugins.contentstree.ui.AddContentToCurrentSelectionClientSideElement;

/**
 * Static client side element for adding content under the currently selected orgunit, or the root orgunit if there is no selection.
 */
public class AddOrgUnitToCurrentClientSideElement extends AddContentToCurrentSelectionClientSideElement
{
    /** The RootOrgUnitProvider */
    private RootOrgUnitProvider _rootOrgUnitProvider;
    
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _rootOrgUnitProvider = (RootOrgUnitProvider) smanager.lookup(RootOrgUnitProvider.ROLE);
        super.service(smanager);
    }
    /**
     * Gets the id of the root OrgUnit.
     * @return the root orgunit id
     */
    @Callable (rights = "ODF_Rights_OrgUnit_Add")
    public String getRootOrgUnitId()
    {
        return _rootOrgUnitProvider.getRootId();
    }
}
