/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.content.code;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;

/**
 * Abstract class for a static {@link UniqueCodeGenerator}
 */
public abstract class AbstractUniqueCodeGenerator implements UniqueCodeGenerator, Configurable, PluginAware
{
    /** The plugin name */
    protected String _pluginName;

    private I18nizableText _label;
    private String _id;

    public String getId()
    {
        return _id;
    }
    
    public I18nizableText getLabel()
    {
        return _label;
    }
    
    public void setPluginInfo(String pluginName, String featureName, String id)
    {
        _id = id;
        _pluginName = pluginName;
    }

    public void configure(Configuration configuration) throws ConfigurationException
    {
        _label = I18nizableText.parseI18nizableText(configuration.getChild("label"), "plugin." + _pluginName);
    }
}
