/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.init;

import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

/**
 * ODF reference table data description to import on initialization.
 * Files to import are listed in the plugin description.
 */
public class OdfRefTableDataAsFilesList extends OdfRefTableDataAsFolder
{
    /** List of data filenames to import */
    protected List<String> _dataFilenames;
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        super.configure(configuration);
        _dataFilenames = new ArrayList<>();
        for (Configuration fileConfiguration : configuration.getChild("files").getChildren("file"))
        {
            _dataFilenames.add(fileConfiguration.getValue());
        }
    }
    
    @Override
    protected List<String> getDataFiles()
    {
        return _dataFilenames.stream()
            .map(filename -> _dataFolder + FileSystems.getDefault().getSeparator() + filename)
            .toList();
    }
}
