/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.program.generators;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.cms.content.ContentGenerator;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;

/**
 * {@link Generator} for rendering ODF content data potentially synchronized.
 */
public class ODFContentGenerator extends ContentGenerator
{
    /** The Ametys resolver */
    protected AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _resolver = (AmetysObjectResolver) serviceManager.lookup(AmetysObjectResolver.ROLE);
    }
    
    /**
     * Sax the existing translations
     * @param translations The translations
     * @throws SAXException if an error occurs
     */
    protected void saxTranslations (Map<String, String> translations) throws SAXException
    {
        XMLUtils.startElement(contentHandler, "translations");
        for (String lang : translations.keySet())
        {
            String contentId = translations.get(lang);
            try
            {
                Content translatedContent = _resolver.resolveById(contentId);
                XMLUtils.createElement(contentHandler, lang, translatedContent.getId());
            }
            catch (UnknownAmetysObjectException e)
            {
                // Ignore, the translation just doesn't exist in the live workspace.
            }
        }
        XMLUtils.endElement(contentHandler, "translations");
    }
}
